/*
 * Decompiled with CFR 0.152.
 */
package de.unhappycodings.quarry.client.gui.widgets.base;

import com.mojang.blaze3d.vertex.PoseStack;
import de.unhappycodings.quarry.client.gui.GuiUtil;
import de.unhappycodings.quarry.client.gui.widgets.ModButton;
import de.unhappycodings.quarry.common.container.base.BaseScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public abstract class BaseWidget
extends AbstractWidget {
    public final BaseScreen<?> screen;
    protected final List<BaseWidget> children = new ArrayList<BaseWidget>();
    protected BlockEntity tile;
    protected Minecraft minecraft = Minecraft.m_91087_();
    protected int leftPos;
    protected int topPos;

    public BaseWidget(int x, int y, int width, int height, BlockEntity tile, BaseScreen<?> screen) {
        super(screen.getGuiLeft() + x, screen.getGuiTop() + y, width, height, (Component)Component.m_237119_());
        this.tile = tile;
        this.screen = screen;
        this.leftPos = screen.getGuiLeft();
        this.topPos = screen.getGuiTop();
    }

    public BaseWidget(int x, int y, int width, int height, int imageWidth, int imageHeight) {
        super((width - imageWidth) / 2 + x, (height - imageHeight) / 2 + y, width, height, (Component)Component.m_237119_());
        this.screen = null;
        this.leftPos = (width - imageWidth) / 2;
        this.topPos = (height - imageHeight) / 2;
    }

    public void m_7428_(@NotNull PoseStack matrixStack, int mouseX, int mouseY) {
        this.children.forEach(child -> child.m_7428_(matrixStack, mouseX, mouseY));
    }

    public void m_6305_(@NotNull PoseStack matrixStack, int x, int y, float partialTicks) {
        GuiUtil.reset();
        for (BaseWidget child : this.children) {
            child.m_6305_(matrixStack, x, y, this.minecraft.m_91297_());
        }
    }

    public void m_7906_(@NotNull PoseStack matrixStack, @NotNull Minecraft minecraft, int pMouseX, int pMouseY) {
        GuiUtil.reset();
        this.m_7428_(matrixStack, pMouseX, pMouseY);
    }

    public void m_5716_(double pMouseX, double pMouseY) {
        for (BaseWidget child : this.children) {
            if (!(child instanceof ModButton)) continue;
            child.m_5716_(pMouseX, pMouseY);
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        for (BaseWidget child : this.children) {
            if (!(child instanceof ModButton)) continue;
            child.m_6375_(pMouseX, pMouseY, pButton);
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public void m_7435_(@NotNull SoundManager pHandler) {
        if (this instanceof ModButton) {
            super.m_7435_(pHandler);
        }
    }

    public <ELEMENT extends BaseWidget> ELEMENT addChild(ELEMENT child) {
        this.children.add(child);
        return child;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return super.m_5953_(mouseX, mouseY) || this.children.stream().anyMatch(child -> child.m_5953_(mouseX, mouseY));
    }

    public void drawText(String text, PoseStack stack, int x, int y) {
        Minecraft.m_91087_().f_91062_.m_92883_(stack, text, (float)(this.leftPos - this.f_93618_ / 2 - x - Minecraft.m_91087_().f_91062_.m_92895_(text) / 2), (float)(this.topPos + y), 0x404040);
    }

    public void drawText(Component text, PoseStack stack, int x, int y) {
        Minecraft.m_91087_().f_91062_.m_92889_(stack, text, (float)(this.leftPos - this.f_93618_ / 2 - x - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)text) / 2), (float)(this.topPos + y), 0x404040);
    }

    public void renderComponentTooltip(PoseStack poseStack, List<Component> components, int x, int y) {
        if (this.screen != null) {
            this.screen.m_96597_(poseStack, components, x, y);
        }
    }

    public void m_142291_(@NotNull NarrationElementOutput narrationElementOutput) {
    }
}

